<?php
if (!empty($_POST)) {
	//this portion should strip-out the card number, exp date, cvv and zip
	var_dump($_POST);
	die;
}
// Decide if you want to use a swipe card reader on the page
$use_card_reader = true;

// Define the secret ticket_hash_key used for hashing the variables
$ticket_hash_key = 'REPLACE THIS';

// Define variables for generating the required hash
$location_id = 'REPLACE THIS';
$timestamp = time();
$order_id = mt_rand();

// Generate the secure hash, making sure the variables
// are in the proper sequence.
$data = $location_id . $timestamp . $order_id;
$key = hash_hmac('sha256', $data, $ticket_hash_key);
?>
<html>
<head>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>
<script src="js/api.jquery.js"></script>
<style type="text/css">
#myform label {
	line-height: 30px;
}
.error {
	border-style: solid;
	border-color: red;
}
</style>
<script>
$(document).ready(function(){
	// This will setup the javascript variables based on data provided by the server
	$("#myform").ticket({
		timestamp : "<?= $timestamp ?>",
		signature : "<?= $key ?>",
		location_id : "<?= $location_id ?>",
		order_id : "<?= $order_id ?>"
		//url: "card ticket url here... by default it points to the sandbox"
	});
});
</script>
<?php
if ($use_card_reader) {
?>
<script src="js/card_reader.js"></script>
<script>
$(document).ready(function() {
	$(function () {
		var reader = new CardReader();
		reader.observe(document);
		reader.cardError(function () {
			alert("A read error occurred");
		});
		reader.cardRead(function (value) {
			parseTrackData('card_number', 'exp_date','account_holder_name');
		});
	});
});
</script>
<?php
}
?>
</head>
<body>
<!--- In this implementation, all elements that you do not want to be received by your system shall
have a class named "ticketed". This will submit them to get the ticket, then the ticket id will
be used in place of the credit card information. Also, each element needs to have a data-ticket
attribute to determine the name of it in the post data to be sent in to the server
The required elements that need to be submitted to create a ticket are:
	card_number
	cvv
	exp_date
//---->
<form method="POST" id="myform">
	<div class="errorSummary"></div>
	<label for="account_holder_name">Customer name: </label><input type="text" name="account_holder_name"> <br>
	<label for="card_number">Credit card number: </label><input type="text" name="card_number" class="ticketed" data-ticket="card_number"> <br>
	<label for="cvv">CVV: </label><input type="text" name="cvv" class="ticketed" data-ticket="cvv"> <br>
	<label for="exp_date">Exp Date: </label> <input type="text" name="exp_date" class="ticketed" data-ticket="exp_date"> <br>
	<label for="zip">Zip: </label> <input type="text" name="zip" class="ticketed" data-ticket="billing_zip"> <br>
	<input type="submit" value="submit">
</form>
</body>
</html>
